package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Certificate(
    certificateIdentifier: Optional[String] = Optional.Absent,
    certificateType: Optional[String] = Optional.Absent,
    thumbprint: Optional[String] = Optional.Absent,
    validFrom: Optional[TStamp] = Optional.Absent,
    validTill: Optional[TStamp] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Certificate
      .builder()
      .optionallyWith(
        certificateIdentifier.map(value => value: java.lang.String)
      )(_.certificateIdentifier)
      .optionallyWith(certificateType.map(value => value: java.lang.String))(
        _.certificateType
      )
      .optionallyWith(thumbprint.map(value => value: java.lang.String))(
        _.thumbprint
      )
      .optionallyWith(validFrom.map(value => TStamp.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validTill.map(value => TStamp.unwrap(value): Instant))(
        _.validTill
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.Certificate.ReadOnly =
    zio.aws.docdb.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.Certificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.Certificate =
      zio.aws.docdb.model.Certificate(
        certificateIdentifier.map(value => value),
        certificateType.map(value => value),
        thumbprint.map(value => value),
        validFrom.map(value => value),
        validTill.map(value => value),
        certificateArn.map(value => value)
      )
    def certificateIdentifier: Optional[String]
    def certificateType: Optional[String]
    def thumbprint: Optional[String]
    def validFrom: Optional[TStamp]
    def validTill: Optional[TStamp]
    def certificateArn: Optional[String]
    def getCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifier)
    def getCertificateType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateType", certificateType)
    def getThumbprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("thumbprint", thumbprint)
    def getValidFrom: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidTill: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validTill", validTill)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.Certificate
  ) extends zio.aws.docdb.model.Certificate.ReadOnly {
    override val certificateIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateIdentifier())
      .map(value => value: String)
    override val certificateType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateType())
      .map(value => value: String)
    override val thumbprint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.thumbprint())
      .map(value => value: String)
    override val validFrom: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.validFrom())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val validTill: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.validTill())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.Certificate
  ): zio.aws.docdb.model.Certificate.ReadOnly = new Wrapper(impl)
}
