package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyDbClusterParameterGroupResponse(
    dbClusterParameterGroup: Optional[
      zio.aws.docdb.model.DBClusterParameterGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse = {
    import CopyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroup.map(value => value.buildAwsValue())
      )(_.dbClusterParameterGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.docdb.model.CopyDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object CopyDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CopyDbClusterParameterGroupResponse =
      zio.aws.docdb.model.CopyDbClusterParameterGroupResponse(
        dbClusterParameterGroup.map(value => value.asEditable)
      )
    def dbClusterParameterGroup
        : Optional[zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly]
    def getDbClusterParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterParameterGroup",
      dbClusterParameterGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse
  ) extends zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroup
        : Optional[zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroup())
        .map(value => zio.aws.docdb.model.DBClusterParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse
  ): zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
