package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyDbClusterSnapshotResponse(
    dbClusterSnapshot: Optional[zio.aws.docdb.model.DBClusterSnapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse = {
    import CopyDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly =
    zio.aws.docdb.model.CopyDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object CopyDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CopyDbClusterSnapshotResponse =
      zio.aws.docdb.model.CopyDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : Optional[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse
  ) extends zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : Optional[zio.aws.docdb.model.DBClusterSnapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshot())
        .map(value => zio.aws.docdb.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse
  ): zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
