package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{
  GlobalClusterIdentifier,
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDbClusterRequest(
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    dbClusterIdentifier: String,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    engine: String,
    engineVersion: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.docdb.model.Tag]] = Optional.Absent,
    storageEncrypted: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    preSignedUrl: Optional[String] = Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    globalClusterIdentifier: Optional[GlobalClusterIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest = {
    import CreateDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterIdentifier.map(value =>
          GlobalClusterIdentifier.unwrap(value): java.lang.String
        )
      )(_.globalClusterIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbClusterRequest.ReadOnly =
    zio.aws.docdb.model.CreateDbClusterRequest.wrap(buildAwsValue())
}
object CreateDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbClusterRequest =
      zio.aws.docdb.model.CreateDbClusterRequest(
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterIdentifier,
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        dbSubnetGroupName.map(value => value),
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        masterUserPassword.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value),
        globalClusterIdentifier.map(value => value)
      )
    def availabilityZones: Optional[List[String]]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def dbClusterIdentifier: String
    def dbClusterParameterGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def dbSubnetGroupName: Optional[String]
    def engine: String
    def engineVersion: Optional[String]
    def port: Optional[IntegerOptional]
    def masterUsername: Optional[String]
    def masterUserPassword: Optional[String]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def tags: Optional[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def storageEncrypted: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def preSignedUrl: Optional[String]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def deletionProtection: Optional[BooleanOptional]
    def globalClusterIdentifier: Optional[GlobalClusterIdentifier]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterIdentifier
        : ZIO[Any, AwsError, GlobalClusterIdentifier] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
  ) extends zio.aws.docdb.model.CreateDbClusterRequest.ReadOnly {
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val engine: String = impl.engine(): String
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val tags: Optional[List[zio.aws.docdb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Tag.wrap(item)
          }.toList
        )
    override val storageEncrypted: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEncrypted())
        .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val preSignedUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preSignedUrl())
      .map(value => value: String)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val globalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value =>
          zio.aws.docdb.model.primitives.GlobalClusterIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest
  ): zio.aws.docdb.model.CreateDbClusterRequest.ReadOnly = new Wrapper(impl)
}
