package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{IntegerOptional, BooleanOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDbInstanceRequest(
    dbInstanceIdentifier: String,
    dbInstanceClass: String,
    engine: String,
    availabilityZone: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.docdb.model.Tag]] = Optional.Absent,
    dbClusterIdentifier: String,
    promotionTier: Optional[IntegerOptional] = Optional.Absent,
    enablePerformanceInsights: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest = {
    import CreateDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .dbInstanceClass(dbInstanceClass: java.lang.String)
      .engine(engine: java.lang.String)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbInstanceRequest.ReadOnly =
    zio.aws.docdb.model.CreateDbInstanceRequest.wrap(buildAwsValue())
}
object CreateDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbInstanceRequest =
      zio.aws.docdb.model.CreateDbInstanceRequest(
        dbInstanceIdentifier,
        dbInstanceClass,
        engine,
        availabilityZone.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterIdentifier,
        promotionTier.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value)
      )
    def dbInstanceIdentifier: String
    def dbInstanceClass: String
    def engine: String
    def availabilityZone: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def tags: Optional[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def dbClusterIdentifier: String
    def promotionTier: Optional[IntegerOptional]
    def enablePerformanceInsights: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceClass)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
  ) extends zio.aws.docdb.model.CreateDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val dbInstanceClass: String = impl.dbInstanceClass(): String
    override val engine: String = impl.engine(): String
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val tags: Optional[List[zio.aws.docdb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Tag.wrap(item)
          }.toList
        )
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
    override val enablePerformanceInsights: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest
  ): zio.aws.docdb.model.CreateDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
