package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDbInstanceResponse(
    dbInstance: Optional[zio.aws.docdb.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse = {
    import CreateDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly =
    zio.aws.docdb.model.CreateDbInstanceResponse.wrap(buildAwsValue())
}
object CreateDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateDbInstanceResponse =
      zio.aws.docdb.model
        .CreateDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.docdb.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse
  ) extends zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly {
    override val dbInstance: Optional[zio.aws.docdb.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.docdb.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse
  ): zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
