package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DBClusterMember(
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    isClusterWriter: Optional[Boolean] = Optional.Absent,
    dbClusterParameterGroupStatus: Optional[String] = Optional.Absent,
    promotionTier: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBClusterMember = {
    import DBClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterMember
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(isClusterWriter.map(value => value: java.lang.Boolean))(
        _.isClusterWriter
      )
      .optionallyWith(
        dbClusterParameterGroupStatus.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupStatus)
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBClusterMember.ReadOnly =
    zio.aws.docdb.model.DBClusterMember.wrap(buildAwsValue())
}
object DBClusterMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBClusterMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBClusterMember =
      zio.aws.docdb.model.DBClusterMember(
        dbInstanceIdentifier.map(value => value),
        isClusterWriter.map(value => value),
        dbClusterParameterGroupStatus.map(value => value),
        promotionTier.map(value => value)
      )
    def dbInstanceIdentifier: Optional[String]
    def isClusterWriter: Optional[Boolean]
    def dbClusterParameterGroupStatus: Optional[String]
    def promotionTier: Optional[IntegerOptional]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getIsClusterWriter: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isClusterWriter", isClusterWriter)
    def getDbClusterParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupStatus",
        dbClusterParameterGroupStatus
      )
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterMember
  ) extends zio.aws.docdb.model.DBClusterMember.ReadOnly {
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val isClusterWriter: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isClusterWriter())
      .map(value => value: Boolean)
    override val dbClusterParameterGroupStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupStatus())
        .map(value => value: String)
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterMember
  ): zio.aws.docdb.model.DBClusterMember.ReadOnly = new Wrapper(impl)
}
