package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBClusterSnapshotAttribute(
    attributeName: Optional[String] = Optional.Absent,
    attributeValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute = {
    import DBClusterSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeValues)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBClusterSnapshotAttribute.ReadOnly =
    zio.aws.docdb.model.DBClusterSnapshotAttribute.wrap(buildAwsValue())
}
object DBClusterSnapshotAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBClusterSnapshotAttribute =
      zio.aws.docdb.model.DBClusterSnapshotAttribute(
        attributeName.map(value => value),
        attributeValues.map(value => value)
      )
    def attributeName: Optional[String]
    def attributeValues: Optional[List[String]]
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeValues", attributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute
  ) extends zio.aws.docdb.model.DBClusterSnapshotAttribute.ReadOnly {
    override val attributeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => value: String)
    override val attributeValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute
  ): zio.aws.docdb.model.DBClusterSnapshotAttribute.ReadOnly = new Wrapper(impl)
}
