package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBClusterSnapshotAttributesResult(
    dbClusterSnapshotIdentifier: Optional[String] = Optional.Absent,
    dbClusterSnapshotAttributes: Optional[
      Iterable[zio.aws.docdb.model.DBClusterSnapshotAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult = {
    import DBClusterSnapshotAttributesResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult
      .builder()
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(
        dbClusterSnapshotAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterSnapshotAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly =
    zio.aws.docdb.model.DBClusterSnapshotAttributesResult.wrap(buildAwsValue())
}
object DBClusterSnapshotAttributesResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBClusterSnapshotAttributesResult =
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult(
        dbClusterSnapshotIdentifier.map(value => value),
        dbClusterSnapshotAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterSnapshotIdentifier: Optional[String]
    def dbClusterSnapshotAttributes: Optional[
      List[zio.aws.docdb.model.DBClusterSnapshotAttribute.ReadOnly]
    ]
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getDbClusterSnapshotAttributes: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBClusterSnapshotAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterSnapshotAttributes",
      dbClusterSnapshotAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult
  ) extends zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly {
    override val dbClusterSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshotIdentifier())
        .map(value => value: String)
    override val dbClusterSnapshotAttributes: Optional[
      List[zio.aws.docdb.model.DBClusterSnapshotAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterSnapshotAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.DBClusterSnapshotAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult
  ): zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly =
    new Wrapper(impl)
}
