package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{IntegerOptional, Integer, TStamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DBInstance(
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    dbInstanceStatus: Optional[String] = Optional.Absent,
    endpoint: Optional[zio.aws.docdb.model.Endpoint] = Optional.Absent,
    instanceCreateTime: Optional[TStamp] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[Integer] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.docdb.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    dbSubnetGroup: Optional[zio.aws.docdb.model.DBSubnetGroup] =
      Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    pendingModifiedValues: Optional[zio.aws.docdb.model.PendingModifiedValues] =
      Optional.Absent,
    latestRestorableTime: Optional[TStamp] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    statusInfos: Optional[Iterable[zio.aws.docdb.model.DBInstanceStatusInfo]] =
      Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    dbiResourceId: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    promotionTier: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceArn: Optional[String] = Optional.Absent,
    enabledCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBInstance = {
    import DBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBInstance
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(dbInstanceStatus.map(value => value: java.lang.String))(
        _.dbInstanceStatus
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        statusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusInfos)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(promotionTier.map(value => value: java.lang.Integer))(
        _.promotionTier
      )
      .optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(
        _.dbInstanceArn
      )
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBInstance.ReadOnly =
    zio.aws.docdb.model.DBInstance.wrap(buildAwsValue())
}
object DBInstance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.DBInstance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBInstance =
      zio.aws.docdb.model.DBInstance(
        dbInstanceIdentifier.map(value => value),
        dbInstanceClass.map(value => value),
        engine.map(value => value),
        dbInstanceStatus.map(value => value),
        endpoint.map(value => value.asEditable),
        instanceCreateTime.map(value => value),
        preferredBackupWindow.map(value => value),
        backupRetentionPeriod.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        dbSubnetGroup.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        latestRestorableTime.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        publiclyAccessible.map(value => value),
        statusInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterIdentifier.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbiResourceId.map(value => value),
        caCertificateIdentifier.map(value => value),
        promotionTier.map(value => value),
        dbInstanceArn.map(value => value),
        enabledCloudwatchLogsExports.map(value => value)
      )
    def dbInstanceIdentifier: Optional[String]
    def dbInstanceClass: Optional[String]
    def engine: Optional[String]
    def dbInstanceStatus: Optional[String]
    def endpoint: Optional[zio.aws.docdb.model.Endpoint.ReadOnly]
    def instanceCreateTime: Optional[TStamp]
    def preferredBackupWindow: Optional[String]
    def backupRetentionPeriod: Optional[Integer]
    def vpcSecurityGroups: Optional[
      List[zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def availabilityZone: Optional[String]
    def dbSubnetGroup: Optional[zio.aws.docdb.model.DBSubnetGroup.ReadOnly]
    def preferredMaintenanceWindow: Optional[String]
    def pendingModifiedValues
        : Optional[zio.aws.docdb.model.PendingModifiedValues.ReadOnly]
    def latestRestorableTime: Optional[TStamp]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def publiclyAccessible: Optional[Boolean]
    def statusInfos
        : Optional[List[zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly]]
    def dbClusterIdentifier: Optional[String]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def dbiResourceId: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def promotionTier: Optional[IntegerOptional]
    def dbInstanceArn: Optional[String]
    def enabledCloudwatchLogsExports: Optional[List[String]]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getDbInstanceStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatus)
    def getEndpoint: ZIO[Any, AwsError, zio.aws.docdb.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.PendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("statusInfos", statusInfos)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getDbInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArn)
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBInstance
  ) extends zio.aws.docdb.model.DBInstance.ReadOnly {
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val dbInstanceStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceStatus())
      .map(value => value: String)
    override val endpoint: Optional[zio.aws.docdb.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.docdb.model.Endpoint.wrap(value))
    override val instanceCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCreateTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: Integer)
    override val vpcSecurityGroups: Optional[
      List[zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val dbSubnetGroup
        : Optional[zio.aws.docdb.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.docdb.model.DBSubnetGroup.wrap(value))
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val pendingModifiedValues
        : Optional[zio.aws.docdb.model.PendingModifiedValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingModifiedValues())
        .map(value => zio.aws.docdb.model.PendingModifiedValues.wrap(value))
    override val latestRestorableTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRestorableTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val statusInfos
        : Optional[List[zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusInfos())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.DBInstanceStatusInfo.wrap(item)
          }.toList
        )
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val dbiResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
    override val dbInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceArn())
      .map(value => value: String)
    override val enabledCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBInstance
  ): zio.aws.docdb.model.DBInstance.ReadOnly = new Wrapper(impl)
}
