package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBInstanceStatusInfo(
    statusType: Optional[String] = Optional.Absent,
    normal: Optional[Boolean] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo = {
    import DBInstanceStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
      .builder()
      .optionallyWith(statusType.map(value => value: java.lang.String))(
        _.statusType
      )
      .optionallyWith(normal.map(value => value: java.lang.Boolean))(_.normal)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly =
    zio.aws.docdb.model.DBInstanceStatusInfo.wrap(buildAwsValue())
}
object DBInstanceStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBInstanceStatusInfo =
      zio.aws.docdb.model.DBInstanceStatusInfo(
        statusType.map(value => value),
        normal.map(value => value),
        status.map(value => value),
        message.map(value => value)
      )
    def statusType: Optional[String]
    def normal: Optional[Boolean]
    def status: Optional[String]
    def message: Optional[String]
    def getStatusType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusType", statusType)
    def getNormal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("normal", normal)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
  ) extends zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly {
    override val statusType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusType())
      .map(value => value: String)
    override val normal: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.normal())
      .map(value => value: Boolean)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo
  ): zio.aws.docdb.model.DBInstanceStatusInfo.ReadOnly = new Wrapper(impl)
}
