package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBSubnetGroup(
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    dbSubnetGroupDescription: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    subnetGroupStatus: Optional[String] = Optional.Absent,
    subnets: Optional[Iterable[zio.aws.docdb.model.Subnet]] = Optional.Absent,
    dbSubnetGroupArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBSubnetGroup = {
    import DBSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBSubnetGroup
      .builder()
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        dbSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.dbSubnetGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(dbSubnetGroupArn.map(value => value: java.lang.String))(
        _.dbSubnetGroupArn
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBSubnetGroup.ReadOnly =
    zio.aws.docdb.model.DBSubnetGroup.wrap(buildAwsValue())
}
object DBSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBSubnetGroup =
      zio.aws.docdb.model.DBSubnetGroup(
        dbSubnetGroupName.map(value => value),
        dbSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSubnetGroupArn.map(value => value)
      )
    def dbSubnetGroupName: Optional[String]
    def dbSubnetGroupDescription: Optional[String]
    def vpcId: Optional[String]
    def subnetGroupStatus: Optional[String]
    def subnets: Optional[List[zio.aws.docdb.model.Subnet.ReadOnly]]
    def dbSubnetGroupArn: Optional[String]
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescription)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getDbSubnetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupArn", dbSubnetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBSubnetGroup
  ) extends zio.aws.docdb.model.DBSubnetGroup.ReadOnly {
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val dbSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroupDescription())
        .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val subnetGroupStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupStatus())
      .map(value => value: String)
    override val subnets: Optional[List[zio.aws.docdb.model.Subnet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Subnet.wrap(item)
          }.toList
        )
    override val dbSubnetGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBSubnetGroup
  ): zio.aws.docdb.model.DBSubnetGroup.ReadOnly = new Wrapper(impl)
}
