package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.docdb.model.primitives.GlobalClusterIdentifier
import scala.jdk.CollectionConverters.*
final case class DeleteGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest = {
    import DeleteGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DeleteGlobalClusterRequest.ReadOnly =
    zio.aws.docdb.model.DeleteGlobalClusterRequest.wrap(buildAwsValue())
}
object DeleteGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteGlobalClusterRequest =
      zio.aws.docdb.model.DeleteGlobalClusterRequest(globalClusterIdentifier)
    def globalClusterIdentifier: GlobalClusterIdentifier
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest
  ) extends zio.aws.docdb.model.DeleteGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.docdb.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest
  ): zio.aws.docdb.model.DeleteGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
