package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDbClustersRequest(
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.docdb.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest = {
    import DescribeDbClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeDbClustersRequest.ReadOnly =
    zio.aws.docdb.model.DescribeDbClustersRequest.wrap(buildAwsValue())
}
object DescribeDbClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbClustersRequest =
      zio.aws.docdb.model.DescribeDbClustersRequest(
        dbClusterIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def dbClusterIdentifier: Optional[String]
    def filters: Optional[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
  ) extends zio.aws.docdb.model.DescribeDbClustersRequest.ReadOnly {
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest
  ): zio.aws.docdb.model.DescribeDbClustersRequest.ReadOnly = new Wrapper(impl)
}
