package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEventCategoriesResponse(
    eventCategoriesMapList: Optional[
      Iterable[zio.aws.docdb.model.EventCategoriesMap]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse = {
    import DescribeEventCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse
      .builder()
      .optionallyWith(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventCategoriesMapList)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly =
    zio.aws.docdb.model.DescribeEventCategoriesResponse.wrap(buildAwsValue())
}
object DescribeEventCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeEventCategoriesResponse =
      zio.aws.docdb.model.DescribeEventCategoriesResponse(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eventCategoriesMapList
        : Optional[List[zio.aws.docdb.model.EventCategoriesMap.ReadOnly]]
    def getEventCategoriesMapList: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.EventCategoriesMap.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventCategoriesMapList",
      eventCategoriesMapList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse
  ) extends zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly {
    override val eventCategoriesMapList
        : Optional[List[zio.aws.docdb.model.EventCategoriesMap.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCategoriesMapList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.EventCategoriesMap.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse
  ): zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly = new Wrapper(
    impl
  )
}
