package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDbClusterResponse(
    dbCluster: Optional[zio.aws.docdb.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse = {
    import ModifyDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly =
    zio.aws.docdb.model.ModifyDbClusterResponse.wrap(buildAwsValue())
}
object ModifyDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbClusterResponse =
      zio.aws.docdb.model
        .ModifyDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Optional[zio.aws.docdb.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse
  ) extends zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.docdb.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.docdb.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse
  ): zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly = new Wrapper(impl)
}
