package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{IntegerOptional, BooleanOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyDbInstanceRequest(
    dbInstanceIdentifier: String,
    dbInstanceClass: Optional[String] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    newDBInstanceIdentifier: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    promotionTier: Optional[IntegerOptional] = Optional.Absent,
    enablePerformanceInsights: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest = {
    import ModifyDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        newDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.newDBInstanceIdentifier)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbInstanceRequest.ReadOnly =
    zio.aws.docdb.model.ModifyDbInstanceRequest.wrap(buildAwsValue())
}
object ModifyDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbInstanceRequest =
      zio.aws.docdb.model.ModifyDbInstanceRequest(
        dbInstanceIdentifier,
        dbInstanceClass.map(value => value),
        applyImmediately.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        newDBInstanceIdentifier.map(value => value),
        caCertificateIdentifier.map(value => value),
        promotionTier.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value)
      )
    def dbInstanceIdentifier: String
    def dbInstanceClass: Optional[String]
    def applyImmediately: Optional[Boolean]
    def preferredMaintenanceWindow: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def newDBInstanceIdentifier: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def promotionTier: Optional[IntegerOptional]
    def enablePerformanceInsights: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getNewDBInstanceIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBInstanceIdentifier", newDBInstanceIdentifier)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
  ) extends zio.aws.docdb.model.ModifyDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val newDBInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newDBInstanceIdentifier())
        .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
    override val enablePerformanceInsights: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest
  ): zio.aws.docdb.model.ModifyDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
