package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDbSubnetGroupResponse(
    dbSubnetGroup: Optional[zio.aws.docdb.model.DBSubnetGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse = {
    import ModifyDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse
      .builder()
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly =
    zio.aws.docdb.model.ModifyDbSubnetGroupResponse.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbSubnetGroupResponse =
      zio.aws.docdb.model.ModifyDbSubnetGroupResponse(
        dbSubnetGroup.map(value => value.asEditable)
      )
    def dbSubnetGroup: Optional[zio.aws.docdb.model.DBSubnetGroup.ReadOnly]
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse
  ) extends zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly {
    override val dbSubnetGroup
        : Optional[zio.aws.docdb.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.docdb.model.DBSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse
  ): zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
