package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrderableDBInstanceOption(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    availabilityZones: Optional[
      Iterable[zio.aws.docdb.model.AvailabilityZone]
    ] = Optional.Absent,
    vpc: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption = {
    import OrderableDBInstanceOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly =
    zio.aws.docdb.model.OrderableDBInstanceOption.wrap(buildAwsValue())
}
object OrderableDBInstanceOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.OrderableDBInstanceOption =
      zio.aws.docdb.model.OrderableDBInstanceOption(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbInstanceClass.map(value => value),
        licenseModel.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpc.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def dbInstanceClass: Optional[String]
    def licenseModel: Optional[String]
    def availabilityZones
        : Optional[List[zio.aws.docdb.model.AvailabilityZone.ReadOnly]]
    def vpc: Optional[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getVpc: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
  ) extends zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val availabilityZones
        : Optional[List[zio.aws.docdb.model.AvailabilityZone.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.AvailabilityZone.wrap(item)
          }.toList
        )
    override val vpc: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.vpc())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption
  ): zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly = new Wrapper(impl)
}
