package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Parameter(
    parameterName: Optional[String] = Optional.Absent,
    parameterValue: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    applyType: Optional[String] = Optional.Absent,
    dataType: Optional[String] = Optional.Absent,
    allowedValues: Optional[String] = Optional.Absent,
    isModifiable: Optional[Boolean] = Optional.Absent,
    minimumEngineVersion: Optional[String] = Optional.Absent,
    applyMethod: Optional[zio.aws.docdb.model.ApplyMethod] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Parameter
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(applyMethod.map(value => value.unwrap))(_.applyMethod)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.Parameter.ReadOnly =
    zio.aws.docdb.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.Parameter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.Parameter =
      zio.aws.docdb.model.Parameter(
        parameterName.map(value => value),
        parameterValue.map(value => value),
        description.map(value => value),
        source.map(value => value),
        applyType.map(value => value),
        dataType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        minimumEngineVersion.map(value => value),
        applyMethod.map(value => value)
      )
    def parameterName: Optional[String]
    def parameterValue: Optional[String]
    def description: Optional[String]
    def source: Optional[String]
    def applyType: Optional[String]
    def dataType: Optional[String]
    def allowedValues: Optional[String]
    def isModifiable: Optional[Boolean]
    def minimumEngineVersion: Optional[String]
    def applyMethod: Optional[zio.aws.docdb.model.ApplyMethod]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getApplyMethod: ZIO[Any, AwsError, zio.aws.docdb.model.ApplyMethod] =
      AwsError.unwrapOptionField("applyMethod", applyMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.Parameter
  ) extends zio.aws.docdb.model.Parameter.ReadOnly {
    override val parameterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterName())
      .map(value => value: String)
    override val parameterValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterValue())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val applyType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.applyType())
      .map(value => value: String)
    override val dataType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataType())
      .map(value => value: String)
    override val allowedValues: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value => value: String)
    override val isModifiable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isModifiable())
      .map(value => value: Boolean)
    override val minimumEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumEngineVersion())
      .map(value => value: String)
    override val applyMethod: Optional[zio.aws.docdb.model.ApplyMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyMethod())
        .map(value => zio.aws.docdb.model.ApplyMethod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.Parameter
  ): zio.aws.docdb.model.Parameter.ReadOnly = new Wrapper(impl)
}
