package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{BooleanOptional, IntegerOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PendingModifiedValues(
    dbInstanceClass: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    pendingCloudwatchLogsExports: Optional[
      zio.aws.docdb.model.PendingCloudwatchLogsExports
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingModifiedValues
      .builder()
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        pendingCloudwatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudwatchLogsExports)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.PendingModifiedValues.ReadOnly =
    zio.aws.docdb.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.PendingModifiedValues =
      zio.aws.docdb.model.PendingModifiedValues(
        dbInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        masterUserPassword.map(value => value),
        port.map(value => value),
        backupRetentionPeriod.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        dbInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        caCertificateIdentifier.map(value => value),
        dbSubnetGroupName.map(value => value),
        pendingCloudwatchLogsExports.map(value => value.asEditable)
      )
    def dbInstanceClass: Optional[String]
    def allocatedStorage: Optional[IntegerOptional]
    def masterUserPassword: Optional[String]
    def port: Optional[IntegerOptional]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def multiAZ: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def licenseModel: Optional[String]
    def iops: Optional[IntegerOptional]
    def dbInstanceIdentifier: Optional[String]
    def storageType: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def dbSubnetGroupName: Optional[String]
    def pendingCloudwatchLogsExports
        : Optional[zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly]
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPendingCloudwatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudwatchLogsExports",
      pendingCloudwatchLogsExports
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.PendingModifiedValues
  ) extends zio.aws.docdb.model.PendingModifiedValues.ReadOnly {
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val pendingCloudwatchLogsExports
        : Optional[zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingCloudwatchLogsExports())
        .map(value =>
          zio.aws.docdb.model.PendingCloudwatchLogsExports.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.PendingModifiedValues
  ): zio.aws.docdb.model.PendingModifiedValues.ReadOnly = new Wrapper(impl)
}
