package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RebootDbInstanceResponse(
    dbInstance: Optional[zio.aws.docdb.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse = {
    import RebootDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly =
    zio.aws.docdb.model.RebootDbInstanceResponse.wrap(buildAwsValue())
}
object RebootDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.RebootDbInstanceResponse =
      zio.aws.docdb.model
        .RebootDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.docdb.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse
  ) extends zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly {
    override val dbInstance: Optional[zio.aws.docdb.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.docdb.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse
  ): zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
