package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.docdb.model.primitives.GlobalClusterIdentifier
import scala.jdk.CollectionConverters.*
final case class RemoveFromGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    dbClusterIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest = {
    import RemoveFromGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.RemoveFromGlobalClusterRequest.ReadOnly =
    zio.aws.docdb.model.RemoveFromGlobalClusterRequest.wrap(buildAwsValue())
}
object RemoveFromGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.RemoveFromGlobalClusterRequest =
      zio.aws.docdb.model.RemoveFromGlobalClusterRequest(
        globalClusterIdentifier,
        dbClusterIdentifier
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def dbClusterIdentifier: String
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest
  ) extends zio.aws.docdb.model.RemoveFromGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.docdb.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest
  ): zio.aws.docdb.model.RemoveFromGlobalClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
