package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveTagsFromResourceRequest(
    resourceName: String,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest = {
    import RemoveTagsFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.RemoveTagsFromResourceRequest.ReadOnly =
    zio.aws.docdb.model.RemoveTagsFromResourceRequest.wrap(buildAwsValue())
}
object RemoveTagsFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.RemoveTagsFromResourceRequest =
      zio.aws.docdb.model.RemoveTagsFromResourceRequest(resourceName, tagKeys)
    def resourceName: String
    def tagKeys: List[String]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest
  ) extends zio.aws.docdb.model.RemoveTagsFromResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest
  ): zio.aws.docdb.model.RemoveTagsFromResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
