package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartDbClusterResponse(
    dbCluster: Optional[zio.aws.docdb.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.StartDbClusterResponse = {
    import StartDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.StartDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.StartDbClusterResponse.ReadOnly =
    zio.aws.docdb.model.StartDbClusterResponse.wrap(buildAwsValue())
}
object StartDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.StartDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.StartDbClusterResponse =
      zio.aws.docdb.model
        .StartDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Optional[zio.aws.docdb.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.StartDbClusterResponse
  ) extends zio.aws.docdb.model.StartDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.docdb.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.docdb.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.StartDbClusterResponse
  ): zio.aws.docdb.model.StartDbClusterResponse.ReadOnly = new Wrapper(impl)
}
