package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcSecurityGroupMembership(
    vpcSecurityGroupId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership = {
    import VpcSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership
      .builder()
      .optionallyWith(vpcSecurityGroupId.map(value => value: java.lang.String))(
        _.vpcSecurityGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly =
    zio.aws.docdb.model.VpcSecurityGroupMembership.wrap(buildAwsValue())
}
object VpcSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.VpcSecurityGroupMembership =
      zio.aws.docdb.model.VpcSecurityGroupMembership(
        vpcSecurityGroupId.map(value => value),
        status.map(value => value)
      )
    def vpcSecurityGroupId: Optional[String]
    def status: Optional[String]
    def getVpcSecurityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership
  ) extends zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly {
    override val vpcSecurityGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroupId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership
  ): zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly = new Wrapper(impl)
}
