package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BackupDescription(
    backupDetails: Optional[zio.aws.dynamodb.model.BackupDetails] =
      Optional.Absent,
    sourceTableDetails: Optional[zio.aws.dynamodb.model.SourceTableDetails] =
      Optional.Absent,
    sourceTableFeatureDetails: Optional[
      zio.aws.dynamodb.model.SourceTableFeatureDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BackupDescription = {
    import BackupDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BackupDescription
      .builder()
      .optionallyWith(backupDetails.map(value => value.buildAwsValue()))(
        _.backupDetails
      )
      .optionallyWith(sourceTableDetails.map(value => value.buildAwsValue()))(
        _.sourceTableDetails
      )
      .optionallyWith(
        sourceTableFeatureDetails.map(value => value.buildAwsValue())
      )(_.sourceTableFeatureDetails)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BackupDescription.ReadOnly =
    zio.aws.dynamodb.model.BackupDescription.wrap(buildAwsValue())
}
object BackupDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BackupDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BackupDescription =
      zio.aws.dynamodb.model.BackupDescription(
        backupDetails.map(value => value.asEditable),
        sourceTableDetails.map(value => value.asEditable),
        sourceTableFeatureDetails.map(value => value.asEditable)
      )
    def backupDetails: Optional[zio.aws.dynamodb.model.BackupDetails.ReadOnly]
    def sourceTableDetails
        : Optional[zio.aws.dynamodb.model.SourceTableDetails.ReadOnly]
    def sourceTableFeatureDetails
        : Optional[zio.aws.dynamodb.model.SourceTableFeatureDetails.ReadOnly]
    def getBackupDetails
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BackupDetails.ReadOnly] =
      AwsError.unwrapOptionField("backupDetails", backupDetails)
    def getSourceTableDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.SourceTableDetails.ReadOnly
    ] = AwsError.unwrapOptionField("sourceTableDetails", sourceTableDetails)
    def getSourceTableFeatureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.SourceTableFeatureDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceTableFeatureDetails",
      sourceTableFeatureDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupDescription
  ) extends zio.aws.dynamodb.model.BackupDescription.ReadOnly {
    override val backupDetails
        : Optional[zio.aws.dynamodb.model.BackupDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupDetails())
        .map(value => zio.aws.dynamodb.model.BackupDetails.wrap(value))
    override val sourceTableDetails
        : Optional[zio.aws.dynamodb.model.SourceTableDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceTableDetails())
        .map(value => zio.aws.dynamodb.model.SourceTableDetails.wrap(value))
    override val sourceTableFeatureDetails
        : Optional[zio.aws.dynamodb.model.SourceTableFeatureDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceTableFeatureDetails())
        .map(value =>
          zio.aws.dynamodb.model.SourceTableFeatureDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupDescription
  ): zio.aws.dynamodb.model.BackupDescription.ReadOnly = new Wrapper(impl)
}
