package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  TableName,
  BackupArn,
  BackupSizeBytes,
  Date,
  BackupCreationDateTime,
  BackupName,
  TableArn,
  TableId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BackupSummary(
    tableName: Optional[TableName] = Optional.Absent,
    tableId: Optional[TableId] = Optional.Absent,
    tableArn: Optional[TableArn] = Optional.Absent,
    backupArn: Optional[BackupArn] = Optional.Absent,
    backupName: Optional[BackupName] = Optional.Absent,
    backupCreationDateTime: Optional[BackupCreationDateTime] = Optional.Absent,
    backupExpiryDateTime: Optional[Date] = Optional.Absent,
    backupStatus: Optional[zio.aws.dynamodb.model.BackupStatus] =
      Optional.Absent,
    backupType: Optional[zio.aws.dynamodb.model.BackupType] = Optional.Absent,
    backupSizeBytes: Optional[BackupSizeBytes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BackupSummary = {
    import BackupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BackupSummary
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        tableId.map(value => TableId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        backupArn.map(value => BackupArn.unwrap(value): java.lang.String)
      )(_.backupArn)
      .optionallyWith(
        backupName.map(value => BackupName.unwrap(value): java.lang.String)
      )(_.backupName)
      .optionallyWith(
        backupCreationDateTime.map(value =>
          BackupCreationDateTime.unwrap(value): Instant
        )
      )(_.backupCreationDateTime)
      .optionallyWith(
        backupExpiryDateTime.map(value => Date.unwrap(value): Instant)
      )(_.backupExpiryDateTime)
      .optionallyWith(backupStatus.map(value => value.unwrap))(_.backupStatus)
      .optionallyWith(backupType.map(value => value.unwrap))(_.backupType)
      .optionallyWith(
        backupSizeBytes.map(value =>
          BackupSizeBytes.unwrap(value): java.lang.Long
        )
      )(_.backupSizeBytes)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BackupSummary.ReadOnly =
    zio.aws.dynamodb.model.BackupSummary.wrap(buildAwsValue())
}
object BackupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BackupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BackupSummary =
      zio.aws.dynamodb.model.BackupSummary(
        tableName.map(value => value),
        tableId.map(value => value),
        tableArn.map(value => value),
        backupArn.map(value => value),
        backupName.map(value => value),
        backupCreationDateTime.map(value => value),
        backupExpiryDateTime.map(value => value),
        backupStatus.map(value => value),
        backupType.map(value => value),
        backupSizeBytes.map(value => value)
      )
    def tableName: Optional[TableName]
    def tableId: Optional[TableId]
    def tableArn: Optional[TableArn]
    def backupArn: Optional[BackupArn]
    def backupName: Optional[BackupName]
    def backupCreationDateTime: Optional[BackupCreationDateTime]
    def backupExpiryDateTime: Optional[Date]
    def backupStatus: Optional[zio.aws.dynamodb.model.BackupStatus]
    def backupType: Optional[zio.aws.dynamodb.model.BackupType]
    def backupSizeBytes: Optional[BackupSizeBytes]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTableId: ZIO[Any, AwsError, TableId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getBackupArn: ZIO[Any, AwsError, BackupArn] =
      AwsError.unwrapOptionField("backupArn", backupArn)
    def getBackupName: ZIO[Any, AwsError, BackupName] =
      AwsError.unwrapOptionField("backupName", backupName)
    def getBackupCreationDateTime: ZIO[Any, AwsError, BackupCreationDateTime] =
      AwsError.unwrapOptionField(
        "backupCreationDateTime",
        backupCreationDateTime
      )
    def getBackupExpiryDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("backupExpiryDateTime", backupExpiryDateTime)
    def getBackupStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BackupStatus] =
      AwsError.unwrapOptionField("backupStatus", backupStatus)
    def getBackupType: ZIO[Any, AwsError, zio.aws.dynamodb.model.BackupType] =
      AwsError.unwrapOptionField("backupType", backupType)
    def getBackupSizeBytes: ZIO[Any, AwsError, BackupSizeBytes] =
      AwsError.unwrapOptionField("backupSizeBytes", backupSizeBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupSummary
  ) extends zio.aws.dynamodb.model.BackupSummary.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val tableId: Optional[TableId] = zio.aws.core.internal
      .optionalFromNullable(impl.tableId())
      .map(value => zio.aws.dynamodb.model.primitives.TableId(value))
    override val tableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val backupArn: Optional[BackupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.backupArn())
      .map(value => zio.aws.dynamodb.model.primitives.BackupArn(value))
    override val backupName: Optional[BackupName] = zio.aws.core.internal
      .optionalFromNullable(impl.backupName())
      .map(value => zio.aws.dynamodb.model.primitives.BackupName(value))
    override val backupCreationDateTime: Optional[BackupCreationDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupCreationDateTime())
        .map(value =>
          zio.aws.dynamodb.model.primitives.BackupCreationDateTime(value)
        )
    override val backupExpiryDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.backupExpiryDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val backupStatus: Optional[zio.aws.dynamodb.model.BackupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupStatus())
        .map(value => zio.aws.dynamodb.model.BackupStatus.wrap(value))
    override val backupType: Optional[zio.aws.dynamodb.model.BackupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupType())
        .map(value => zio.aws.dynamodb.model.BackupType.wrap(value))
    override val backupSizeBytes: Optional[BackupSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupSizeBytes())
        .map(value => zio.aws.dynamodb.model.primitives.BackupSizeBytes(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupSummary
  ): zio.aws.dynamodb.model.BackupSummary.ReadOnly = new Wrapper(impl)
}
