package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{AttributeName, TableArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetItemResponse(
    responses: Optional[Map[TableArn, Iterable[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ]]] = Optional.Absent,
    unprocessedKeys: Optional[
      Map[TableArn, zio.aws.dynamodb.model.KeysAndAttributes]
    ] = Optional.Absent,
    consumedCapacity: Optional[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse = {
    import BatchGetItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse
      .builder()
      .optionallyWith(
        responses.map(value =>
          value
            .map({ case (key, value) =>
              (TableArn.unwrap(key): java.lang.String) -> value.map { item =>
                item
                  .map({ case (key, value) =>
                    (AttributeName.unwrap(key): java.lang.String) -> value
                      .buildAwsValue()
                  })
                  .asJava
              }.asJavaCollection
            })
            .asJava
        )
      )(_.responses)
      .optionallyWith(
        unprocessedKeys.map(value =>
          value
            .map({ case (key, value) =>
              (TableArn.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.unprocessedKeys)
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchGetItemResponse.ReadOnly =
    zio.aws.dynamodb.model.BatchGetItemResponse.wrap(buildAwsValue())
}
object BatchGetItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchGetItemResponse =
      zio.aws.dynamodb.model.BatchGetItemResponse(
        responses.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.map({ case (key, value) =>
                key -> value.asEditable
              })
            }
          })
        ),
        unprocessedKeys.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responses: Optional[Map[TableArn, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]]]
    def unprocessedKeys: Optional[
      Map[TableArn, zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly]
    ]
    def consumedCapacity
        : Optional[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def getResponses: ZIO[Any, AwsError, Map[TableArn, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]]] = AwsError.unwrapOptionField("responses", responses)
    def getUnprocessedKeys: ZIO[Any, AwsError, Map[
      TableArn,
      zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedKeys", unprocessedKeys)
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse
  ) extends zio.aws.dynamodb.model.BatchGetItemResponse.ReadOnly {
    override val responses: Optional[Map[TableArn, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.responses())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives
              .TableArn(key) -> value.asScala.map { item =>
              item.asScala
                .map({ case (key, value) =>
                  zio.aws.dynamodb.model.primitives.AttributeName(
                    key
                  ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
                })
                .toMap
            }.toList
          })
          .toMap
      )
    override val unprocessedKeys: Optional[
      Map[TableArn, zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedKeys())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.TableArn(
              key
            ) -> zio.aws.dynamodb.model.KeysAndAttributes.wrap(value)
          })
          .toMap
      )
    override val consumedCapacity
        : Optional[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedCapacity())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse
  ): zio.aws.dynamodb.model.BatchGetItemResponse.ReadOnly = new Wrapper(impl)
}
