package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BillingModeSummary(
    billingMode: Optional[zio.aws.dynamodb.model.BillingMode] = Optional.Absent,
    lastUpdateToPayPerRequestDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BillingModeSummary = {
    import BillingModeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BillingModeSummary
      .builder()
      .optionallyWith(billingMode.map(value => value.unwrap))(_.billingMode)
      .optionallyWith(
        lastUpdateToPayPerRequestDateTime.map(value =>
          Date.unwrap(value): Instant
        )
      )(_.lastUpdateToPayPerRequestDateTime)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BillingModeSummary.ReadOnly =
    zio.aws.dynamodb.model.BillingModeSummary.wrap(buildAwsValue())
}
object BillingModeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BillingModeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BillingModeSummary =
      zio.aws.dynamodb.model.BillingModeSummary(
        billingMode.map(value => value),
        lastUpdateToPayPerRequestDateTime.map(value => value)
      )
    def billingMode: Optional[zio.aws.dynamodb.model.BillingMode]
    def lastUpdateToPayPerRequestDateTime: Optional[Date]
    def getBillingMode: ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingMode", billingMode)
    def getLastUpdateToPayPerRequestDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "lastUpdateToPayPerRequestDateTime",
        lastUpdateToPayPerRequestDateTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BillingModeSummary
  ) extends zio.aws.dynamodb.model.BillingModeSummary.ReadOnly {
    override val billingMode: Optional[zio.aws.dynamodb.model.BillingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingMode())
        .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val lastUpdateToPayPerRequestDateTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateToPayPerRequestDateTime())
        .map(value => zio.aws.dynamodb.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BillingModeSummary
  ): zio.aws.dynamodb.model.BillingModeSummary.ReadOnly = new Wrapper(impl)
}
