package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  IndexName,
  ConsumedCapacityUnits,
  TableArn
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConsumedCapacity(
    tableName: Optional[TableArn] = Optional.Absent,
    capacityUnits: Optional[ConsumedCapacityUnits] = Optional.Absent,
    readCapacityUnits: Optional[ConsumedCapacityUnits] = Optional.Absent,
    writeCapacityUnits: Optional[ConsumedCapacityUnits] = Optional.Absent,
    table: Optional[zio.aws.dynamodb.model.Capacity] = Optional.Absent,
    localSecondaryIndexes: Optional[
      Map[IndexName, zio.aws.dynamodb.model.Capacity]
    ] = Optional.Absent,
    globalSecondaryIndexes: Optional[
      Map[IndexName, zio.aws.dynamodb.model.Capacity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity = {
    import ConsumedCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
      .builder()
      .optionallyWith(
        tableName.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        capacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.capacityUnits)
      .optionallyWith(
        readCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.writeCapacityUnits)
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value
            .map({ case (key, value) =>
              (IndexName.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value
            .map({ case (key, value) =>
              (IndexName.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.globalSecondaryIndexes)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly =
    zio.aws.dynamodb.model.ConsumedCapacity.wrap(buildAwsValue())
}
object ConsumedCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ConsumedCapacity =
      zio.aws.dynamodb.model.ConsumedCapacity(
        tableName.map(value => value),
        capacityUnits.map(value => value),
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value),
        table.map(value => value.asEditable),
        localSecondaryIndexes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        globalSecondaryIndexes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def tableName: Optional[TableArn]
    def capacityUnits: Optional[ConsumedCapacityUnits]
    def readCapacityUnits: Optional[ConsumedCapacityUnits]
    def writeCapacityUnits: Optional[ConsumedCapacityUnits]
    def table: Optional[zio.aws.dynamodb.model.Capacity.ReadOnly]
    def localSecondaryIndexes
        : Optional[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]]
    def globalSecondaryIndexes
        : Optional[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]]
    def getTableName: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("capacityUnits", capacityUnits)
    def getReadCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
    def getTable: ZIO[Any, AwsError, zio.aws.dynamodb.model.Capacity.ReadOnly] =
      AwsError.unwrapOptionField("table", table)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, Map[
      IndexName,
      zio.aws.dynamodb.model.Capacity.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, Map[
      IndexName,
      zio.aws.dynamodb.model.Capacity.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
  ) extends zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly {
    override val tableName: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val capacityUnits: Optional[ConsumedCapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
        )
    override val readCapacityUnits: Optional[ConsumedCapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
        )
    override val writeCapacityUnits: Optional[ConsumedCapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
        )
    override val table: Optional[zio.aws.dynamodb.model.Capacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.table())
        .map(value => zio.aws.dynamodb.model.Capacity.wrap(value))
    override val localSecondaryIndexes
        : Optional[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localSecondaryIndexes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives
                .IndexName(key) -> zio.aws.dynamodb.model.Capacity.wrap(value)
            })
            .toMap
        )
    override val globalSecondaryIndexes
        : Optional[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalSecondaryIndexes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives
                .IndexName(key) -> zio.aws.dynamodb.model.Capacity.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
  ): zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly = new Wrapper(impl)
}
