package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.{BackupName, TableArn}
import scala.jdk.CollectionConverters.*
final case class CreateBackupRequest(
    tableName: TableArn,
    backupName: BackupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest = {
    import CreateBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
      .builder()
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .backupName(BackupName.unwrap(backupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateBackupRequest.ReadOnly =
    zio.aws.dynamodb.model.CreateBackupRequest.wrap(buildAwsValue())
}
object CreateBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateBackupRequest =
      zio.aws.dynamodb.model.CreateBackupRequest(tableName, backupName)
    def tableName: TableArn
    def backupName: BackupName
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
    def getBackupName: ZIO[Any, Nothing, BackupName] = ZIO.succeed(backupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
  ) extends zio.aws.dynamodb.model.CreateBackupRequest.ReadOnly {
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
    override val backupName: BackupName =
      zio.aws.dynamodb.model.primitives.BackupName(impl.backupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
  ): zio.aws.dynamodb.model.CreateBackupRequest.ReadOnly = new Wrapper(impl)
}
