package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class CreateGlobalTableRequest(
    globalTableName: TableName,
    replicationGroup: Iterable[zio.aws.dynamodb.model.Replica]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest = {
    import CreateGlobalTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest
      .builder()
      .globalTableName(TableName.unwrap(globalTableName): java.lang.String)
      .replicationGroup(replicationGroup.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateGlobalTableRequest.ReadOnly =
    zio.aws.dynamodb.model.CreateGlobalTableRequest.wrap(buildAwsValue())
}
object CreateGlobalTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateGlobalTableRequest =
      zio.aws.dynamodb.model.CreateGlobalTableRequest(
        globalTableName,
        replicationGroup.map { item =>
          item.asEditable
        }
      )
    def globalTableName: TableName
    def replicationGroup: List[zio.aws.dynamodb.model.Replica.ReadOnly]
    def getGlobalTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(globalTableName)
    def getReplicationGroup
        : ZIO[Any, Nothing, List[zio.aws.dynamodb.model.Replica.ReadOnly]] =
      ZIO.succeed(replicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest
  ) extends zio.aws.dynamodb.model.CreateGlobalTableRequest.ReadOnly {
    override val globalTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.globalTableName())
    override val replicationGroup
        : List[zio.aws.dynamodb.model.Replica.ReadOnly] = impl
      .replicationGroup()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.Replica.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest
  ): zio.aws.dynamodb.model.CreateGlobalTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
