package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ResourcePolicy,
  DeletionProtectionEnabled,
  TableArn
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTableRequest(
    attributeDefinitions: Iterable[zio.aws.dynamodb.model.AttributeDefinition],
    tableName: TableArn,
    keySchema: Iterable[zio.aws.dynamodb.model.KeySchemaElement],
    localSecondaryIndexes: Optional[
      Iterable[zio.aws.dynamodb.model.LocalSecondaryIndex]
    ] = Optional.Absent,
    globalSecondaryIndexes: Optional[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndex]
    ] = Optional.Absent,
    billingMode: Optional[zio.aws.dynamodb.model.BillingMode] = Optional.Absent,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent,
    streamSpecification: Optional[zio.aws.dynamodb.model.StreamSpecification] =
      Optional.Absent,
    sseSpecification: Optional[zio.aws.dynamodb.model.SSESpecification] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.dynamodb.model.Tag]] = Optional.Absent,
    tableClass: Optional[zio.aws.dynamodb.model.TableClass] = Optional.Absent,
    deletionProtectionEnabled: Optional[DeletionProtectionEnabled] =
      Optional.Absent,
    warmThroughput: Optional[zio.aws.dynamodb.model.WarmThroughput] =
      Optional.Absent,
    resourcePolicy: Optional[ResourcePolicy] = Optional.Absent,
    onDemandThroughput: Optional[zio.aws.dynamodb.model.OnDemandThroughput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateTableRequest = {
    import CreateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
      .builder()
      .attributeDefinitions(attributeDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .keySchema(keySchema.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(billingMode.map(value => value.unwrap))(_.billingMode)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(tableClass.map(value => value.unwrap))(_.tableClass)
      .optionallyWith(
        deletionProtectionEnabled.map(value =>
          DeletionProtectionEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtectionEnabled)
      .optionallyWith(warmThroughput.map(value => value.buildAwsValue()))(
        _.warmThroughput
      )
      .optionallyWith(
        resourcePolicy.map(value =>
          ResourcePolicy.unwrap(value): java.lang.String
        )
      )(_.resourcePolicy)
      .optionallyWith(onDemandThroughput.map(value => value.buildAwsValue()))(
        _.onDemandThroughput
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateTableRequest.ReadOnly =
    zio.aws.dynamodb.model.CreateTableRequest.wrap(buildAwsValue())
}
object CreateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateTableRequest =
      zio.aws.dynamodb.model.CreateTableRequest(
        attributeDefinitions.map { item =>
          item.asEditable
        },
        tableName,
        keySchema.map { item =>
          item.asEditable
        },
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        billingMode.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        streamSpecification.map(value => value.asEditable),
        sseSpecification.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableClass.map(value => value),
        deletionProtectionEnabled.map(value => value),
        warmThroughput.map(value => value.asEditable),
        resourcePolicy.map(value => value),
        onDemandThroughput.map(value => value.asEditable)
      )
    def attributeDefinitions
        : List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]
    def tableName: TableArn
    def keySchema: List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]
    def localSecondaryIndexes
        : Optional[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]]
    def globalSecondaryIndexes
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]]
    def billingMode: Optional[zio.aws.dynamodb.model.BillingMode]
    def provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def streamSpecification
        : Optional[zio.aws.dynamodb.model.StreamSpecification.ReadOnly]
    def sseSpecification
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly]
    def tags: Optional[List[zio.aws.dynamodb.model.Tag.ReadOnly]]
    def tableClass: Optional[zio.aws.dynamodb.model.TableClass]
    def deletionProtectionEnabled: Optional[DeletionProtectionEnabled]
    def warmThroughput: Optional[zio.aws.dynamodb.model.WarmThroughput.ReadOnly]
    def resourcePolicy: Optional[ResourcePolicy]
    def onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly]
    def getAttributeDefinitions: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.AttributeDefinition.ReadOnly
    ]] = ZIO.succeed(attributeDefinitions)
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
    def getKeySchema: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = ZIO.succeed(keySchema)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getBillingMode: ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingMode", billingMode)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.StreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getSseSpecification
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField("sseSpecification", sseSpecification)
    def getTags: ZIO[Any, AwsError, List[zio.aws.dynamodb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTableClass: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClass", tableClass)
    def getDeletionProtectionEnabled
        : ZIO[Any, AwsError, DeletionProtectionEnabled] = AwsError
      .unwrapOptionField("deletionProtectionEnabled", deletionProtectionEnabled)
    def getWarmThroughput
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.WarmThroughput.ReadOnly] =
      AwsError.unwrapOptionField("warmThroughput", warmThroughput)
    def getResourcePolicy: ZIO[Any, AwsError, ResourcePolicy] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
    def getOnDemandThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly
    ] = AwsError.unwrapOptionField("onDemandThroughput", onDemandThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
  ) extends zio.aws.dynamodb.model.CreateTableRequest.ReadOnly {
    override val attributeDefinitions
        : List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly] = impl
      .attributeDefinitions()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.AttributeDefinition.wrap(item)
      }
      .toList
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
    override val keySchema
        : List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly] = impl
      .keySchema()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
      }
      .toList
    override val localSecondaryIndexes
        : Optional[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localSecondaryIndexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.LocalSecondaryIndex.wrap(item)
          }.toList
        )
    override val globalSecondaryIndexes
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalSecondaryIndexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.GlobalSecondaryIndex.wrap(item)
          }.toList
        )
    override val billingMode: Optional[zio.aws.dynamodb.model.BillingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingMode())
        .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val streamSpecification
        : Optional[zio.aws.dynamodb.model.StreamSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSpecification())
        .map(value => zio.aws.dynamodb.model.StreamSpecification.wrap(value))
    override val sseSpecification
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseSpecification())
        .map(value => zio.aws.dynamodb.model.SSESpecification.wrap(value))
    override val tags: Optional[List[zio.aws.dynamodb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.Tag.wrap(item)
          }.toList
        )
    override val tableClass: Optional[zio.aws.dynamodb.model.TableClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableClass())
        .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
    override val deletionProtectionEnabled
        : Optional[DeletionProtectionEnabled] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionProtectionEnabled())
      .map(value =>
        zio.aws.dynamodb.model.primitives.DeletionProtectionEnabled(value)
      )
    override val warmThroughput
        : Optional[zio.aws.dynamodb.model.WarmThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warmThroughput())
        .map(value => zio.aws.dynamodb.model.WarmThroughput.wrap(value))
    override val resourcePolicy: Optional[ResourcePolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePolicy())
        .map(value => zio.aws.dynamodb.model.primitives.ResourcePolicy(value))
    override val onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandThroughput())
        .map(value => zio.aws.dynamodb.model.OnDemandThroughput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
  ): zio.aws.dynamodb.model.CreateTableRequest.ReadOnly = new Wrapper(impl)
}
