package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.AttributeName
import scala.jdk.CollectionConverters.*
final case class DeleteRequest(
    key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteRequest = {
    import DeleteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteRequest
      .builder()
      .key(
        key
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteRequest.ReadOnly =
    zio.aws.dynamodb.model.DeleteRequest.wrap(buildAwsValue())
}
object DeleteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteRequest =
      zio.aws.dynamodb.model.DeleteRequest(key.map({ case (key, value) =>
        key -> value.asEditable
      }))
    def key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def getKey: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteRequest
  ) extends zio.aws.dynamodb.model.DeleteRequest.ReadOnly {
    override val key
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .key()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteRequest
  ): zio.aws.dynamodb.model.DeleteRequest.ReadOnly = new Wrapper(impl)
}
