package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PolicyRevisionId, ResourceArnString}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteResourcePolicyRequest(
    resourceArn: ResourceArnString,
    expectedRevisionId: Optional[PolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        expectedRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.expectedRevisionId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.dynamodb.model.DeleteResourcePolicyRequest.wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteResourcePolicyRequest =
      zio.aws.dynamodb.model.DeleteResourcePolicyRequest(
        resourceArn,
        expectedRevisionId.map(value => value)
      )
    def resourceArn: ResourceArnString
    def expectedRevisionId: Optional[PolicyRevisionId]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getExpectedRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("expectedRevisionId", expectedRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest
  ) extends zio.aws.dynamodb.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString(impl.resourceArn())
    override val expectedRevisionId: Optional[PolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedRevisionId())
        .map(value => zio.aws.dynamodb.model.primitives.PolicyRevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest
  ): zio.aws.dynamodb.model.DeleteResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
