package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PolicyRevisionId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteResourcePolicyResponse(
    revisionId: Optional[PolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse = {
    import DeleteResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse
      .builder()
      .optionallyWith(
        revisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.revisionId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteResourcePolicyResponse.ReadOnly =
    zio.aws.dynamodb.model.DeleteResourcePolicyResponse.wrap(buildAwsValue())
}
object DeleteResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteResourcePolicyResponse =
      zio.aws.dynamodb.model
        .DeleteResourcePolicyResponse(revisionId.map(value => value))
    def revisionId: Optional[PolicyRevisionId]
    def getRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse
  ) extends zio.aws.dynamodb.model.DeleteResourcePolicyResponse.ReadOnly {
    override val revisionId: Optional[PolicyRevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.dynamodb.model.primitives.PolicyRevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse
  ): zio.aws.dynamodb.model.DeleteResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
