package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableArn
import scala.jdk.CollectionConverters.*
final case class DescribeContinuousBackupsRequest(tableName: TableArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest = {
    import DescribeContinuousBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest
      .builder()
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeContinuousBackupsRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeContinuousBackupsRequest
      .wrap(buildAwsValue())
}
object DescribeContinuousBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeContinuousBackupsRequest =
      zio.aws.dynamodb.model.DescribeContinuousBackupsRequest(tableName)
    def tableName: TableArn
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest
  ) extends zio.aws.dynamodb.model.DescribeContinuousBackupsRequest.ReadOnly {
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest
  ): zio.aws.dynamodb.model.DescribeContinuousBackupsRequest.ReadOnly =
    new Wrapper(impl)
}
