package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{IndexName, TableArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeContributorInsightsRequest(
    tableName: TableArn,
    indexName: Optional[IndexName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest = {
    import DescribeContributorInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest
      .builder()
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeContributorInsightsRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeContributorInsightsRequest
      .wrap(buildAwsValue())
}
object DescribeContributorInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeContributorInsightsRequest =
      zio.aws.dynamodb.model.DescribeContributorInsightsRequest(
        tableName,
        indexName.map(value => value)
      )
    def tableName: TableArn
    def indexName: Optional[IndexName]
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest
  ) extends zio.aws.dynamodb.model.DescribeContributorInsightsRequest.ReadOnly {
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest
  ): zio.aws.dynamodb.model.DescribeContributorInsightsRequest.ReadOnly =
    new Wrapper(impl)
}
