package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.ImportArn
import scala.jdk.CollectionConverters.*
final case class DescribeImportRequest(importArn: ImportArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest = {
    import DescribeImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest
      .builder()
      .importArn(ImportArn.unwrap(importArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeImportRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeImportRequest.wrap(buildAwsValue())
}
object DescribeImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeImportRequest =
      zio.aws.dynamodb.model.DescribeImportRequest(importArn)
    def importArn: ImportArn
    def getImportArn: ZIO[Any, Nothing, ImportArn] = ZIO.succeed(importArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest
  ) extends zio.aws.dynamodb.model.DescribeImportRequest.ReadOnly {
    override val importArn: ImportArn =
      zio.aws.dynamodb.model.primitives.ImportArn(impl.importArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest
  ): zio.aws.dynamodb.model.DescribeImportRequest.ReadOnly = new Wrapper(impl)
}
