package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableArn
import scala.jdk.CollectionConverters.*
final case class DescribeTableReplicaAutoScalingRequest(tableName: TableArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest = {
    import DescribeTableReplicaAutoScalingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest
      .builder()
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingRequest
      .wrap(buildAwsValue())
}
object DescribeTableReplicaAutoScalingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingRequest =
      zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingRequest(tableName)
    def tableName: TableArn
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest
  ) extends zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingRequest.ReadOnly {
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest
  ): zio.aws.dynamodb.model.DescribeTableReplicaAutoScalingRequest.ReadOnly =
    new Wrapper(impl)
}
