package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{StreamArn, TableArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisableKinesisStreamingDestinationRequest(
    tableName: TableArn,
    streamArn: StreamArn,
    enableKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest = {
    import DisableKinesisStreamingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
      .builder()
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .streamArn(StreamArn.unwrap(streamArn): java.lang.String)
      .optionallyWith(
        enableKinesisStreamingConfiguration.map(value => value.buildAwsValue())
      )(_.enableKinesisStreamingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest.ReadOnly =
    zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest
      .wrap(buildAwsValue())
}
object DisableKinesisStreamingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest =
      zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest(
        tableName,
        streamArn,
        enableKinesisStreamingConfiguration.map(value => value.asEditable)
      )
    def tableName: TableArn
    def streamArn: StreamArn
    def enableKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration.ReadOnly
    ]
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
    def getStreamArn: ZIO[Any, Nothing, StreamArn] = ZIO.succeed(streamArn)
    def getEnableKinesisStreamingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "enableKinesisStreamingConfiguration",
      enableKinesisStreamingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
  ) extends zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest.ReadOnly {
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
    override val streamArn: StreamArn =
      zio.aws.dynamodb.model.primitives.StreamArn(impl.streamArn())
    override val enableKinesisStreamingConfiguration: Optional[
      zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.enableKinesisStreamingConfiguration())
      .map(value =>
        zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
  ): zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
