package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnableKinesisStreamingConfiguration(
    approximateCreationDateTimePrecision: Optional[
      zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingConfiguration = {
    import EnableKinesisStreamingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingConfiguration
      .builder()
      .optionallyWith(
        approximateCreationDateTimePrecision.map(value => value.unwrap)
      )(_.approximateCreationDateTimePrecision)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration.ReadOnly =
    zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration
      .wrap(buildAwsValue())
}
object EnableKinesisStreamingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration =
      zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration(
        approximateCreationDateTimePrecision.map(value => value)
      )
    def approximateCreationDateTimePrecision
        : Optional[zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision]
    def getApproximateCreationDateTimePrecision: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision
    ] = AwsError.unwrapOptionField(
      "approximateCreationDateTimePrecision",
      approximateCreationDateTimePrecision
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingConfiguration
  ) extends zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration.ReadOnly {
    override val approximateCreationDateTimePrecision: Optional[
      zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.approximateCreationDateTimePrecision())
      .map(value =>
        zio.aws.dynamodb.model.ApproximateCreationDateTimePrecision.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingConfiguration
  ): zio.aws.dynamodb.model.EnableKinesisStreamingConfiguration.ReadOnly =
    new Wrapper(impl)
}
