package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait ExportFormat {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ExportFormat
}
object ExportFormat {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ExportFormat
  ): zio.aws.dynamodb.model.ExportFormat = value match {
    case software.amazon.awssdk.services.dynamodb.model.ExportFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportFormat.DYNAMODB_JSON =>
      val r = DYNAMODB_JSON
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportFormat.ION =>
      val r = ION
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.ExportFormat {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportFormat =
      software.amazon.awssdk.services.dynamodb.model.ExportFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object DYNAMODB_JSON extends zio.aws.dynamodb.model.ExportFormat {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportFormat =
      software.amazon.awssdk.services.dynamodb.model.ExportFormat.DYNAMODB_JSON
  }
  case object ION extends zio.aws.dynamodb.model.ExportFormat {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportFormat =
      software.amazon.awssdk.services.dynamodb.model.ExportFormat.ION
  }
}
