package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ExpressionAttributeNameVariable,
  ProjectionExpression,
  TableArn,
  AttributeName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Get(
    key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue],
    tableName: TableArn,
    projectionExpression: Optional[ProjectionExpression] = Optional.Absent,
    expressionAttributeNames: Optional[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Get = {
    import Get.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Get
      .builder()
      .key(
        key
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .tableName(TableArn.unwrap(tableName): java.lang.String)
      .optionallyWith(
        projectionExpression.map(value =>
          ProjectionExpression.unwrap(value): java.lang.String
        )
      )(_.projectionExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable
                .unwrap(key): java.lang.String) -> (AttributeName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Get.ReadOnly =
    zio.aws.dynamodb.model.Get.wrap(buildAwsValue())
}
object Get {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Get] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Get = zio.aws.dynamodb.model.Get(
      key.map({ case (key, value) =>
        key -> value.asEditable
      }),
      tableName,
      projectionExpression.map(value => value),
      expressionAttributeNames.map(value => value)
    )
    def key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def tableName: TableArn
    def projectionExpression: Optional[ProjectionExpression]
    def expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]]
    def getKey: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(key)
    def getTableName: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableName)
    def getProjectionExpression: ZIO[Any, AwsError, ProjectionExpression] =
      AwsError.unwrapOptionField("projectionExpression", projectionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Get
  ) extends zio.aws.dynamodb.model.Get.ReadOnly {
    override val key
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .key()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
    override val tableName: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableName())
    override val projectionExpression: Optional[ProjectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectionExpression())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ProjectionExpression(value)
        )
    override val expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expressionAttributeNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
                key
              ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Get
  ): zio.aws.dynamodb.model.Get.ReadOnly = new Wrapper(impl)
}
