package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.ResourceArnString
import scala.jdk.CollectionConverters.*
final case class GetResourcePolicyRequest(resourceArn: ResourceArnString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest = {
    import GetResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GetResourcePolicyRequest.ReadOnly =
    zio.aws.dynamodb.model.GetResourcePolicyRequest.wrap(buildAwsValue())
}
object GetResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GetResourcePolicyRequest =
      zio.aws.dynamodb.model.GetResourcePolicyRequest(resourceArn)
    def resourceArn: ResourceArnString
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest
  ) extends zio.aws.dynamodb.model.GetResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest
  ): zio.aws.dynamodb.model.GetResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
