package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PolicyRevisionId, ResourcePolicy}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResourcePolicyResponse(
    policy: Optional[ResourcePolicy] = Optional.Absent,
    revisionId: Optional[PolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => ResourcePolicy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(
        revisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.revisionId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.dynamodb.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GetResourcePolicyResponse =
      zio.aws.dynamodb.model.GetResourcePolicyResponse(
        policy.map(value => value),
        revisionId.map(value => value)
      )
    def policy: Optional[ResourcePolicy]
    def revisionId: Optional[PolicyRevisionId]
    def getPolicy: ZIO[Any, AwsError, ResourcePolicy] =
      AwsError.unwrapOptionField("policy", policy)
    def getRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse
  ) extends zio.aws.dynamodb.model.GetResourcePolicyResponse.ReadOnly {
    override val policy: Optional[ResourcePolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.dynamodb.model.primitives.ResourcePolicy(value))
    override val revisionId: Optional[PolicyRevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.dynamodb.model.primitives.PolicyRevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse
  ): zio.aws.dynamodb.model.GetResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
