package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GlobalSecondaryIndex(
    indexName: IndexName,
    keySchema: Iterable[zio.aws.dynamodb.model.KeySchemaElement],
    projection: zio.aws.dynamodb.model.Projection,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent,
    onDemandThroughput: Optional[zio.aws.dynamodb.model.OnDemandThroughput] =
      Optional.Absent,
    warmThroughput: Optional[zio.aws.dynamodb.model.WarmThroughput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex = {
    import GlobalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .keySchema(keySchema.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .projection(projection.buildAwsValue())
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(onDemandThroughput.map(value => value.buildAwsValue()))(
        _.onDemandThroughput
      )
      .optionallyWith(warmThroughput.map(value => value.buildAwsValue()))(
        _.warmThroughput
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndex.wrap(buildAwsValue())
}
object GlobalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalSecondaryIndex =
      zio.aws.dynamodb.model.GlobalSecondaryIndex(
        indexName,
        keySchema.map { item =>
          item.asEditable
        },
        projection.asEditable,
        provisionedThroughput.map(value => value.asEditable),
        onDemandThroughput.map(value => value.asEditable),
        warmThroughput.map(value => value.asEditable)
      )
    def indexName: IndexName
    def keySchema: List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]
    def projection: zio.aws.dynamodb.model.Projection.ReadOnly
    def provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly]
    def warmThroughput: Optional[zio.aws.dynamodb.model.WarmThroughput.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getKeySchema: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = ZIO.succeed(keySchema)
    def getProjection
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.Projection.ReadOnly] =
      ZIO.succeed(projection)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getOnDemandThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly
    ] = AwsError.unwrapOptionField("onDemandThroughput", onDemandThroughput)
    def getWarmThroughput
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.WarmThroughput.ReadOnly] =
      AwsError.unwrapOptionField("warmThroughput", warmThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val keySchema
        : List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly] = impl
      .keySchema()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
      }
      .toList
    override val projection: zio.aws.dynamodb.model.Projection.ReadOnly =
      zio.aws.dynamodb.model.Projection.wrap(impl.projection())
    override val provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandThroughput())
        .map(value => zio.aws.dynamodb.model.OnDemandThroughput.wrap(value))
    override val warmThroughput
        : Optional[zio.aws.dynamodb.model.WarmThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warmThroughput())
        .map(value => zio.aws.dynamodb.model.WarmThroughput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex
  ): zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly = new Wrapper(impl)
}
