package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GlobalSecondaryIndexInfo(
    indexName: Optional[IndexName] = Optional.Absent,
    keySchema: Optional[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] =
      Optional.Absent,
    projection: Optional[zio.aws.dynamodb.model.Projection] = Optional.Absent,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent,
    onDemandThroughput: Optional[zio.aws.dynamodb.model.OnDemandThroughput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo = {
    import GlobalSecondaryIndexInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(onDemandThroughput.map(value => value.buildAwsValue()))(
        _.onDemandThroughput
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.wrap(buildAwsValue())
}
object GlobalSecondaryIndexInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalSecondaryIndexInfo =
      zio.aws.dynamodb.model.GlobalSecondaryIndexInfo(
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable),
        provisionedThroughput.map(value => value.asEditable),
        onDemandThroughput.map(value => value.asEditable)
      )
    def indexName: Optional[IndexName]
    def keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def projection: Optional[zio.aws.dynamodb.model.Projection.ReadOnly]
    def provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.Projection.ReadOnly] =
      AwsError.unwrapOptionField("projection", projection)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getOnDemandThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly
    ] = AwsError.unwrapOptionField("onDemandThroughput", onDemandThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySchema())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
          }.toList
        )
    override val projection
        : Optional[zio.aws.dynamodb.model.Projection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projection())
        .map(value => zio.aws.dynamodb.model.Projection.wrap(value))
    override val provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val onDemandThroughput
        : Optional[zio.aws.dynamodb.model.OnDemandThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandThroughput())
        .map(value => zio.aws.dynamodb.model.OnDemandThroughput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
  ): zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly = new Wrapper(
    impl
  )
}
