package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PositiveLongObject
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GlobalSecondaryIndexWarmThroughputDescription(
    readUnitsPerSecond: Optional[PositiveLongObject] = Optional.Absent,
    writeUnitsPerSecond: Optional[PositiveLongObject] = Optional.Absent,
    status: Optional[zio.aws.dynamodb.model.IndexStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription = {
    import GlobalSecondaryIndexWarmThroughputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription
      .builder()
      .optionallyWith(
        readUnitsPerSecond.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.readUnitsPerSecond)
      .optionallyWith(
        writeUnitsPerSecond.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.writeUnitsPerSecond)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription
      .wrap(buildAwsValue())
}
object GlobalSecondaryIndexWarmThroughputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription =
      zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription(
        readUnitsPerSecond.map(value => value),
        writeUnitsPerSecond.map(value => value),
        status.map(value => value)
      )
    def readUnitsPerSecond: Optional[PositiveLongObject]
    def writeUnitsPerSecond: Optional[PositiveLongObject]
    def status: Optional[zio.aws.dynamodb.model.IndexStatus]
    def getReadUnitsPerSecond: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("readUnitsPerSecond", readUnitsPerSecond)
    def getWriteUnitsPerSecond: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("writeUnitsPerSecond", writeUnitsPerSecond)
    def getStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.IndexStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription.ReadOnly {
    override val readUnitsPerSecond: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readUnitsPerSecond())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val writeUnitsPerSecond: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeUnitsPerSecond())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val status: Optional[zio.aws.dynamodb.model.IndexStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.dynamodb.model.IndexStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription
  ): zio.aws.dynamodb.model.GlobalSecondaryIndexWarmThroughputDescription.ReadOnly =
    new Wrapper(impl)
}
